package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.json.RoleListView;
import gov.va.vinci.dart.json.RoleView;

import java.util.Collection;

import org.springframework.stereotype.Component;

@Component
public class RoleListViewBuilder {
	public RoleListView build(final Collection<Role> roleList) {
		
		RoleListView result = new RoleListView();
		
		if( roleList != null ) {
			for (Role role : roleList) {
				RoleView view = new RoleView();
				view.setId(role.getId());
				view.setName(role.getName());
				view.setDescription(role.getDescription());
				result.getRoles().add(view);
			}
		}//end if
		
		return result;
	}
}
